require("dotenv").config();
const mongoose = require("mongoose");
const bcrypt = require("bcrypt");
const AdminModel = require("./models/Admin.model"); // path सही रखो

mongoose.set("strictQuery", true);

async function createAdmin() {
  try {
    await mongoose.connect(process.env.DB_URL || "mongodb://127.0.0.1:27017/testdb");
    console.log("✅ Connected to DB");

    const email = "admin@gmail.com";
    const password = "admin123";
    const name = "Main Admin";

    const existing = await AdminModel.findOne({ email });
    if (existing) {
      console.log("👑 Admin already exists!");
      process.exit(0);
    }

    const hashed = await bcrypt.hash(password, 5);
    const admin = new AdminModel({
      name,
      email,
      password: hashed,
      userType: "Admin",
      access: "true",
    });

    await admin.save();
    console.log("✅ Admin Created Successfully!");
    console.log("Email:", email);
    console.log("Password:", password);
    process.exit(0);
  } catch (err) {
    console.error("❌ Error:", err.message);
    process.exit(1);
  }
}

createAdmin();
